package com.agilex.healthcare.directscheduling.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObjectCollection;
import com.fasterxml.jackson.annotation.*;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: patelh
 * Date: 9/17/13
 * Time: 11:07 AM
 * To change this template use File | Settings | File Templates.
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonIgnoreProperties(ignoreUnknown = true, value = { "size" })
@XmlRootElement(name = "cancelReasons", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class CancelReasons extends DomainTransferObjectCollection<CancelReason> {

    private static final long serialVersionUID = -923723784542071899L;

    @JsonCreator
    public CancelReasons(){
        super();
    }

    @JsonProperty("cancelReasonsList")
    public Collection<CancelReason> getCancelReasonsList(){
        List<CancelReason> list = new ArrayList<CancelReason>();
        for (CancelReason cancelReason : this) {
            list.add(cancelReason);
        }
        return list;
    }

    public void setCancelReasonsList(Collection<CancelReason> list){
        this.addAll(list);
    }

    @JsonProperty("size")
    public int getListSize(){ return super.size(); }

}
